/*****************************************
*Dateiname: Host.java
*Autor: Utz Roedig modifiziert durch Gunter Wei
*letzte Aenderung: 2.5.97
*Inhalt: Klasse zum Anlegen eines Hostfensters
*****************************************/

import java.awt.*;
import java.util.Vector;

/*****************************************
*Klasse: host
*Beschreibung: Legt ein Fenster fr die Hosteinstellungen an
*****************************************/
public class Host extends Panel {
    Thread t;
    TcpStarter outerparent;
    private HostNetBuffer fromnet;
    private HostNetBuffer tonet;
    TcpProtocol t1;
    SessionControlBlock status=new SessionControlBlock();
    int connectionid=0;
    int i;
    int i_am;

    public Image se;
    public Image cl;

    public Image hostpict0;
    public Image hostpict1;
    public Image hostpict2;

    // Layout
    Panel blpanel   = new Panel();
    Panel pictpanel = new Panel();
    Panel c12panel  = new Panel();
    Panel c3tpanel  = new Panel();
    Pict p1;
    public Label label_1;
    public Label label_2;
    public Checkbox radiobutton_1;
    public CheckboxGroup example_radiobutton = new CheckboxGroup();
    public Checkbox radiobutton_2;
    public Checkbox radiobutton_3;
    public TextField entry_1;


/*****************************************
* Methode: Host
* Beschreibung: initialisiert den Host
* Parameter: Starter-Klasse, titel, netzanschlsse
* Rckgabewert : keiner
*****************************************/
  public Host(TcpStarter home, String label, HostNetBuffer tonet, HostNetBuffer fromnet, int me) {
         this .outerparent=home;
         this .tonet=tonet;
         this .fromnet=fromnet;
	 this .i_am = me;
         t1 = new TcpProtocol(this,outerparent,tonet,fromnet,i_am);

         this.se = se;
         this.cl = cl;
         hostpict0 = cl;
         hostpict1 = cl;
         hostpict2 = cl;
         p1 = new Pict(hostpict0,50,50,40,40);
         setBackground(Color.lightGray);

         // Layout
         setLayout(new GridLayout(2,1,5,5));
         // Picture
         pictpanel.setLayout(new GridLayout(1,1,5,5));
         pictpanel.add(p1);
         //add(pictpanel);

         // bild+label
         blpanel.setLayout(new GridLayout(2,1,2,2));
    	 label_1 = new Label("Connection",Label.CENTER);
         label_1. setFont(new Font("Dialog",Font.PLAIN,14));
    	 //label_1. setText("Connection");
    	 label_2 = new Label("ID",Label.CENTER);
         label_2. setFont(new Font("Dialog",Font.PLAIN,14));
    	 blpanel. add(label_1);
    	 blpanel. add(label_2);
    	 add(blpanel);

        // check1 +2

        c12panel. setLayout(new GridLayout(2,1,2,2));
        radiobutton_1 = new Checkbox();
    	radiobutton_1. setLabel("ID 0");
    	radiobutton_1. setCheckboxGroup(example_radiobutton);
    	radiobutton_1. setState(true);
    	radiobutton_2 = new Checkbox();
    	radiobutton_2. setLabel("ID 1");
    	radiobutton_2. setCheckboxGroup(example_radiobutton);
    	c12panel. add(radiobutton_1);
        c12panel. add(radiobutton_2);
        c3tpanel. setLayout(new GridLayout(2,1,2,2));
        radiobutton_3 = new Checkbox();
    	radiobutton_3. setLabel("Other ID:");
    	radiobutton_3. setCheckboxGroup(example_radiobutton);
    	entry_1 = new TextField(4);
    	entry_1. setText("2");
    	entry_1. disable();
    	c3tpanel. add(radiobutton_3);
    	c3tpanel. add(entry_1);
        add(c12panel);
        //add(c3tpanel);
	validate();
	show();
}

public void clearHistory() {
    i = t1.history.size();
    System.out.println("clearHistory() + size() : "+ i );
    if (i> 0) {
        t1.Clear();
        System.out.println("clearHistory() in Schleife + size() : "+ i );
    }
}

synchronized void updateStatus(){
    if (connectionid>=0){
      status=t1.ConStatus(connectionid);
    }
}
synchronized SessionControlBlock getStatus(){
    return status;
}

synchronized SessionControlBlock getStatus(int id){
    return t1.ConStatus(id);
}

synchronized int getID(){
    return connectionid;
}
synchronized void refreshPict(){
    if (connectionid==0) p1.setPict(hostpict0);
    if (connectionid==1) p1.setPict(hostpict1);
    if (connectionid==2) p1.setPict(hostpict2);
}
synchronized void setPict(boolean type,int id){
    if (type) {
        if (id==0) this.hostpict0=se;
        if (id==1) this.hostpict1=se;
        if (id==2) this.hostpict2=se;
    }
    else {
        if (id==0) this.hostpict0=cl;
        if (id==1) this.hostpict1=cl;
        if (id==2) this.hostpict2=cl;
    }
    refreshPict();
}

synchronized Image getPict(){
    switch(connectionid){
     case 0:
      return hostpict0;
     case 1:
      return hostpict1;
     case 2:
      return hostpict2;
     default:
      return hostpict0;
    }
}


/*****************************************
* Methode: handleEvent
* Beschreibung: Aktionen
* Parameter:  Event
* Rckgabewert : ??
*****************************************/
public boolean handleEvent(Event event) {
        refreshPict();
        if (event.id == Event.ACTION_EVENT && event.target == radiobutton_1) {
            connectionid=0;
            entry_1.disable();
        }
        if (event.id == Event.ACTION_EVENT && event.target == radiobutton_2) {
            connectionid=1;
            entry_1.disable();

        }
        return super.handleEvent(event);
    }
}

